/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.dynaXML;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Templates;
import javax.xml.transform.sax.SAXResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import org.cdlib.xtf.dynaXML.DocLocator;
import org.cdlib.xtf.dynaXML.DynaXMLConfig;
import org.cdlib.xtf.lazyTree.LazyTreeBuilder;
import org.cdlib.xtf.servletBase.TextConfig;
import org.cdlib.xtf.servletBase.TextServlet;
import org.cdlib.xtf.textEngine.IndexUtil;
import org.cdlib.xtf.util.DocTypeDeclRemover;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.StructuredFile;
import org.cdlib.xtf.util.StructuredStore;
import org.cdlib.xtf.util.SubStoreReader;
import org.cdlib.xtf.util.SubStoreWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultDocLocator
implements DocLocator {
    private TextServlet servlet;

    public void setServlet(TextServlet servlet) {
        this.servlet = servlet;
    }

    public synchronized StructuredStore getLazyStore(String indexConfigPath, String indexName, String sourcePath, Templates preFilter, boolean removeDoctypeDecl) throws IOException {
        TextConfig config = this.servlet.getConfig();
        if (config instanceof DynaXMLConfig && !((DynaXMLConfig)config).useLazyFiles) {
            return null;
        }
        if (indexConfigPath == null || indexName == null) {
            return null;
        }
        if (sourcePath.startsWith("http:")) {
            return null;
        }
        if (sourcePath.startsWith("https:")) {
            return null;
        }
        File sourceFile = new File(sourcePath);
        if (!sourceFile.isFile()) {
            return null;
        }
        File lazyFile = this.calcLazyPath(new File(this.servlet.getRealPath("")), new File(indexConfigPath), indexName, new File(sourcePath), false);
        boolean buildLazyFilesAlone = false;
        if (config instanceof DynaXMLConfig) {
            buildLazyFilesAlone = ((DynaXMLConfig)config).buildLazyFilesAlone;
        }
        if (buildLazyFilesAlone && lazyFile.canRead() && sourceFile.lastModified() > lazyFile.lastModified() && this.isPostIndexLazyFile(lazyFile)) {
            lazyFile.delete();
        }
        if (!lazyFile.canRead()) {
            if (!buildLazyFilesAlone) {
                return null;
            }
            boolean stripWhitespace = false;
            try {
                stripWhitespace = IndexUtil.getIndexInfo((File)new File((String)indexConfigPath), (String)indexName).stripWhitespace;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.buildLazyStore(lazyFile, sourcePath, preFilter, removeDoctypeDecl, stripWhitespace);
        }
        return StructuredFile.open(lazyFile);
    }

    public File calcLazyPath(File xtfHome, File idxConfigFile, String idxName, File srcTextFile, boolean createDir) throws IOException {
        return IndexUtil.calcLazyPath(xtfHome, idxConfigFile, idxName, srcTextFile, createDir);
    }

    public InputSource getInputSource(String sourcePath, boolean removeDoctypeDecl) throws IOException {
        if (sourcePath.startsWith("http:") || sourcePath.startsWith("https:")) {
            return new InputSource(sourcePath);
        }
        InputStream inStream = new FileInputStream(sourcePath);
        if (removeDoctypeDecl) {
            inStream = new DocTypeDeclRemover(inStream);
        }
        InputSource inSrc = new InputSource(inStream);
        inSrc.setSystemId(new File(sourcePath).toURL().toString());
        return inSrc;
    }

    private void buildLazyStore(File lazyFile, String sourcePath, Templates preFilter, boolean removeDoctypeDecl, boolean stripWhitespace) throws IOException {
        Path.createPath(lazyFile.getParent());
        File tmpFile = new File(String.valueOf(lazyFile.getAbsolutePath()) + ".tmp");
        Configuration config = new Configuration();
        LazyTreeBuilder lazyBuilder = new LazyTreeBuilder(config);
        StructuredFile lazyStore = StructuredFile.create(tmpFile);
        SubStoreWriter sub = lazyStore.createSubStore("isPostIndexLazyFile");
        sub.writeByte(1);
        sub.close();
        Receiver lazyReceiver = lazyBuilder.begin(lazyStore);
        try {
            ReceivingContentHandler lazyHandler = new ReceivingContentHandler();
            lazyHandler.setReceiver(lazyReceiver);
            lazyHandler.setPipelineConfiguration(lazyReceiver.getPipelineConfiguration());
            SAXParser xmlParser = IndexUtil.createSAXParser();
            FileInputStream inStream = new FileInputStream(sourcePath);
            InputSource inSrc = new InputSource(IndexUtil.filterXMLDocument((InputStream)inStream, xmlParser, removeDoctypeDecl));
            inSrc.setSystemId(new File(sourcePath).toURL().toString());
            LazyPassthru passthru = new LazyPassthru(lazyHandler, stripWhitespace);
            if (preFilter == null) {
                try {
                    xmlParser.parse(inSrc, (DefaultHandler)passthru);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                Templates[] array = new Templates[]{preFilter};
                IndexUtil.applyPreFilters(array, xmlParser.getXMLReader(), inSrc, new SAXResult(passthru));
            }
            catch (Exception e) {
                lazyBuilder.abort(lazyReceiver);
                throw new RuntimeException(e);
            }
            lazyBuilder.finish(lazyReceiver, true);
            tmpFile.renameTo(lazyFile);
        }
        catch (IOException e) {
            lazyBuilder.abort(lazyReceiver);
            throw e;
        }
    }

    private boolean isPostIndexLazyFile(File f) {
        StructuredFile store = null;
        SubStoreReader sub = null;
        boolean ret = false;
        try {
            try {
                store = StructuredFile.open(f);
                sub = store.openSubStore("isPostIndexLazyFile");
                if (sub.readByte() == 1) {
                    ret = true;
                }
            }
            catch (IOException iOException) {
                try {
                    if (sub != null) {
                        sub.close();
                    }
                    if (store != null) {
                        store.close();
                    }
                }
                catch (IOException iOException2) {}
            }
        }
        finally {
            try {
                if (sub != null) {
                    sub.close();
                }
                if (store != null) {
                    store.close();
                }
            }
            catch (IOException iOException) {}
        }
        return ret;
    }

    private static class LazyPassthru
    extends DefaultHandler {
        private StringBuffer charBuf = new StringBuffer();
        private ContentHandler lazyHandler;
        private boolean stripWhitespace;

        public LazyPassthru(ContentHandler lazyHandler, boolean stripWhitespace) {
            this.lazyHandler = lazyHandler;
            this.stripWhitespace = stripWhitespace;
        }

        public void startDocument() throws SAXException {
            this.lazyHandler.startDocument();
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.flushCharacters();
            this.lazyHandler.startElement(uri, localName, qName, atts);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.flushCharacters();
            this.lazyHandler.endElement(uri, localName, qName);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.lazyHandler.processingInstruction(target, data);
        }

        public void endDocument() throws SAXException {
            this.lazyHandler.endDocument();
        }

        public void characters(char[] ch, int start, int length) {
            this.charBuf.append(ch, start, length);
        }

        private void flushCharacters() throws SAXException {
            int i = 0;
            if (this.stripWhitespace) {
                i = 0;
                while (i < this.charBuf.length()) {
                    if (!Character.isWhitespace(this.charBuf.charAt(i))) break;
                    ++i;
                }
            }
            if (i < this.charBuf.length()) {
                this.lazyHandler.characters(this.charBuf.toString().toCharArray(), 0, this.charBuf.length());
            }
            this.charBuf.setLength(0);
        }
    }
}

