/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.cache;

import org.cdlib.xtf.cache.Cache;
import org.cdlib.xtf.cache.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCache<K, V>
extends Cache<K, V> {
    public SimpleCache(int maxEntries, int maxTime) {
        super(maxEntries, maxTime);
    }

    public void set(K key, V value) {
        this.set(key, value, null);
    }

    public synchronized void set(K key, V value, Dependency dependency) {
        if (this.has(key)) {
            Cache.ListEntry entry = (Cache.ListEntry)this.keyMap.get(key);
            entry.value = value;
            entry.dependencies.clear();
            if (dependency != null) {
                entry.dependencies.add(dependency);
            }
            entry.setTime = System.currentTimeMillis();
            this.logAction("Replaced", key, value);
            return;
        }
        Cache.ListEntry entry = new Cache.ListEntry();
        entry.key = key;
        entry.value = value;
        if (dependency != null) {
            entry.dependencies.add(dependency);
        }
        entry.lastUsedTime = entry.setTime = System.currentTimeMillis();
        this.ageList.addTail(entry);
        this.keyMap.put(key, entry);
        this.logAction("Added", key, value);
        this.cleanup();
    }

    public synchronized V get(K key) {
        if (this.has(key)) {
            return ((Cache.ListEntry)this.keyMap.get(key)).value;
        }
        return null;
    }

    public synchronized void addDependency(K key, Dependency d) {
        if (!this.has(key)) {
            return;
        }
        ((Cache.ListEntry)this.keyMap.get(key)).dependencies.add(d);
    }
}

