/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Random;
import junit.framework.TestCase;
import org.apache.lucene.util.LongList;

public class LongListTest
extends TestCase {
    public void testAdd() {
        LongList list = new LongList(2);
        LongListTest.assertTrue((boolean)list.isEmpty());
        list.add(1L);
        LongListTest.assertFalse((boolean)list.isEmpty());
        list.add(2L);
        LongListTest.assertEquals((int)2, (int)list.size());
        LongListTest.assertEquals((long)1L, (long)list.get(0));
        LongListTest.assertEquals((long)2L, (long)list.get(1));
        LongListTest.assertEquals((long)2L, (long)list.getLast());
        list.add(3L);
        LongListTest.assertEquals((int)3, (int)list.size());
        LongListTest.assertEquals((long)3L, (long)list.get(2));
        LongListTest.assertEquals((long)3L, (long)list.getLast());
        list.compact();
        LongListTest.assertEquals((int)3, (int)list.size());
        LongListTest.assertEquals((long)1L, (long)list.get(0));
        LongListTest.assertEquals((long)2L, (long)list.get(1));
        LongListTest.assertEquals((long)3L, (long)list.get(2));
        list.set(1, 89L);
        LongListTest.assertEquals((long)89L, (long)list.get(1));
        long[] array = list.toArray();
        LongListTest.assertEquals((int)3, (int)array.length);
        LongListTest.assertEquals((long)1L, (long)array[0]);
        LongListTest.assertEquals((long)89L, (long)array[1]);
        LongListTest.assertEquals((long)3L, (long)array[2]);
        list.fill(9L);
        LongListTest.assertEquals((long)9L, (long)list.get(0));
        LongListTest.assertEquals((long)9L, (long)list.get(1));
        LongListTest.assertEquals((long)9L, (long)list.get(2));
        list.clear();
        LongListTest.assertEquals((int)0, (int)list.size());
        LongListTest.assertTrue((boolean)list.isEmpty());
    }

    public void testSmall() {
        LongList list = new LongList(0);
        list.add(1L);
        LongListTest.assertFalse((boolean)list.isEmpty());
        list.add(2L);
        LongListTest.assertEquals((int)2, (int)list.size());
        LongListTest.assertEquals((long)1L, (long)list.get(0));
        LongListTest.assertEquals((long)2L, (long)list.get(1));
        LongListTest.assertEquals((long)2L, (long)list.getLast());
        list = new LongList(1);
        list.add(1L);
        LongListTest.assertFalse((boolean)list.isEmpty());
        list.add(2L);
        LongListTest.assertEquals((int)2, (int)list.size());
        LongListTest.assertEquals((long)1L, (long)list.get(0));
        LongListTest.assertEquals((long)2L, (long)list.get(1));
        LongListTest.assertEquals((long)2L, (long)list.getLast());
    }

    public void testSort() {
        LongList list = new LongList();
        int SIZE = 10000;
        Random rand = new Random(1L);
        int i = 0;
        while (i < 10000) {
            list.add(Math.abs(rand.nextLong()));
            ++i;
        }
        list.sort();
        i = 1;
        while (i < 10000) {
            LongListTest.assertTrue((list.get(i - 1) <= list.get(i) ? 1 : 0) != 0);
            ++i;
        }
        list.clear();
        i = 0;
        while (i < 10000) {
            list.add(Math.abs(rand.nextLong()));
            ++i;
        }
        int[] map = list.calcSortMap();
        int i2 = 1;
        while (i2 < 10000) {
            LongListTest.assertTrue((list.get(map[i2 - 1]) <= list.get(map[i2]) ? 1 : 0) != 0);
            ++i2;
        }
        list.remap(map);
        i2 = 1;
        while (i2 < 10000) {
            LongListTest.assertTrue((list.get(i2 - 1) <= list.get(i2) ? 1 : 0) != 0);
            ++i2;
        }
        LongListTest.assertEquals((long)list.get(0), (long)list.get(list.binarySearch(list.get(0))));
        LongListTest.assertEquals((long)list.get(3333), (long)list.get(list.binarySearch(list.get(3333))));
        LongListTest.assertEquals((long)list.get(6666), (long)list.get(list.binarySearch(list.get(6666))));
        LongListTest.assertEquals((long)list.get(9999), (long)list.get(list.binarySearch(list.get(9999))));
    }
}

