/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spelt;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.spelt.SpellWriter;

public class SpellWritingFilter
extends TokenFilter {
    private SpellWriter spellWriter;

    public SpellWritingFilter(TokenStream input, SpellWriter spellWriter) {
        super(input);
        this.spellWriter = spellWriter;
    }

    public Token next() throws IOException {
        Token t = this.input.next();
        if (t == null || t.getPositionIncrement() != 1) {
            this.spellWriter.queueBreak();
        }
        if (t != null) {
            this.spellWriter.queueWord(t.termText());
        }
        return t;
    }
}

