/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spelt;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.spelt.MinimalAnalyzer;
import org.apache.lucene.spelt.SimpleQueryRewriter;
import org.apache.lucene.spelt.SpellReader;

public class QuerySpeller
extends SimpleQueryRewriter {
    private SpellReader spellReader;
    private HashSet<String> fieldSet;
    private LinkedHashSet<String> terms;
    private HashMap<String, String> suggestMap;
    private QueryParser queryParser;

    public QuerySpeller(SpellReader spellReader) {
        this(spellReader, new QueryParser("text", new MinimalAnalyzer()));
    }

    public QuerySpeller(SpellReader spellReader, QueryParser queryParser) {
        this.spellReader = spellReader;
        this.queryParser = queryParser;
        this.validateAnalyzer();
    }

    private void validateAnalyzer() {
        TokenStream toks = this.queryParser.getAnalyzer().tokenStream(this.queryParser.getField(), new StringReader("MixedCaseToken"));
        try {
            Token t;
            while ((t = toks.next()) != null) {
                if (!t.termText().equals("MixedCaseToken")) continue;
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalArgumentException("Unacceptable analyzer passed to QuerySpeller - must not convert to lower case");
    }

    public synchronized String suggest(String inQuery) throws ParseException, IOException {
        return this.suggest(inQuery, null);
    }

    public synchronized String suggest(String inQuery, String[] fields) throws ParseException, IOException {
        if (fields == null) {
            this.fieldSet = null;
        } else {
            this.fieldSet = new HashSet(fields.length);
            String[] stringArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                this.fieldSet.add(f);
                ++n2;
            }
        }
        Query inQueryParsed = this.queryParser.parse(inQuery);
        this.suggestMap = new HashMap();
        this.terms = new LinkedHashSet();
        this.rewriteQuery(inQueryParsed);
        if (this.terms.isEmpty()) {
            return null;
        }
        String[] oldTerms = this.terms.toArray(new String[0]);
        String[] suggTerms = this.spellReader.suggestKeywords(oldTerms);
        if (suggTerms == null) {
            return null;
        }
        int i = 0;
        while (i < oldTerms.length) {
            this.suggestMap.put(oldTerms[i], suggTerms[i]);
            ++i;
        }
        Query rewritten = this.rewriteQuery(inQueryParsed);
        return rewritten.toString(this.queryParser.getField());
    }

    protected Term rewrite(Term t) {
        if (this.fieldSet != null && !this.fieldSet.contains(t.field())) {
            return t;
        }
        String text = t.text();
        this.terms.add(text);
        if (this.suggestMap.containsKey(text)) {
            String suggText = this.suggestMap.get(text);
            if (suggText != null) {
                return new Term(t.field(), suggText);
            }
            return null;
        }
        return t;
    }
}

