/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bigram;

import java.util.Set;
import org.apache.lucene.bigram.BigramQueryRewriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.SpanRangeQuery;

public class BigramSpanRangeQuery
extends SpanRangeQuery {
    private Set stopSet;

    public BigramSpanRangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive, int termLimit) {
        super(lowerTerm, upperTerm, inclusive, termLimit);
    }

    public void setStopWords(Set set) {
        this.stopSet = set;
    }

    protected boolean shouldSkipTerm(Term term) {
        if (this.stopSet == null) {
            return false;
        }
        if (this.stopSet.contains(term.text())) {
            return true;
        }
        return BigramQueryRewriter.isBigram(this.stopSet, term.text());
    }
}

