/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

public final class DatabaseType {
    public static final DatabaseType BTREE = new DatabaseType("BTREE", 1);
    public static final DatabaseType HASH = new DatabaseType("HASH", 2);
    public static final DatabaseType QUEUE = new DatabaseType("QUEUE", 4);
    public static final DatabaseType RECNO = new DatabaseType("RECNO", 3);
    public static final DatabaseType UNKNOWN = new DatabaseType("UNKNOWN", 5);
    private String statusName;
    private int id;

    static DatabaseType fromInt(int type) {
        switch (type) {
            case 1: {
                return BTREE;
            }
            case 2: {
                return HASH;
            }
            case 4: {
                return QUEUE;
            }
            case 3: {
                return RECNO;
            }
            case 5: {
                return UNKNOWN;
            }
        }
        throw new IllegalArgumentException("Unknown database type: " + type);
    }

    private DatabaseType(String statusName, int id) {
        this.statusName = statusName;
        this.id = id;
    }

    int getId() {
        return this.id;
    }

    public String toString() {
        return "DatabaseType." + this.statusName;
    }
}

