/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Environment;
import com.sleepycat.db.internal.DbEnv;

public class DatabaseException
extends Exception {
    private Environment dbenv;
    private int errno;

    public DatabaseException(String s) {
        this(s, 0, (Environment)null);
    }

    public DatabaseException(String s, int errno) {
        this(s, errno, (Environment)null);
    }

    public DatabaseException(String s, int errno, Environment dbenv) {
        super(s);
        this.errno = errno;
        this.dbenv = dbenv;
    }

    DatabaseException(String s, int errno, DbEnv dbenv) {
        this(s, errno, dbenv == null ? null : dbenv.wrapper);
    }

    public Environment getEnvironment() {
        return this.dbenv;
    }

    public int getErrno() {
        return this.errno;
    }

    public String toString() {
        String s = super.toString();
        if (this.errno != 0) {
            s = s + ": " + DbEnv.strerror(this.errno);
        }
        return s;
    }
}

