/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.serial;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBase;
import com.sleepycat.bind.serial.SerialInput;
import com.sleepycat.bind.serial.SerialOutput;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.util.FastInputStream;
import com.sleepycat.util.FastOutputStream;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.IOException;

public class SerialBinding
extends SerialBase
implements EntryBinding {
    private ClassCatalog classCatalog;
    private Class baseClass;

    public SerialBinding(ClassCatalog classCatalog, Class baseClass) {
        if (classCatalog == null) {
            throw new NullPointerException("classCatalog must be non-null");
        }
        this.classCatalog = classCatalog;
        this.baseClass = baseClass;
    }

    public final Class getBaseClass() {
        return this.baseClass;
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Object entryToObject(DatabaseEntry entry) {
        int length = entry.getSize();
        byte[] hdr = SerialOutput.getStreamHeader();
        byte[] bufWithHeader = new byte[length + hdr.length];
        System.arraycopy(hdr, 0, bufWithHeader, 0, hdr.length);
        System.arraycopy(entry.getData(), entry.getOffset(), bufWithHeader, hdr.length, length);
        try {
            SerialInput jin = new SerialInput(new FastInputStream(bufWithHeader, 0, bufWithHeader.length), this.classCatalog, this.getClassLoader());
            return jin.readObject();
        }
        catch (IOException e) {
            throw new RuntimeExceptionWrapper(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeExceptionWrapper(e);
        }
    }

    public void objectToEntry(Object object, DatabaseEntry entry) {
        if (this.baseClass != null && !this.baseClass.isInstance(object)) {
            throw new IllegalArgumentException("Data object class (" + object.getClass() + ") not an instance of binding's base class (" + this.baseClass + ')');
        }
        FastOutputStream fo = this.getSerialOutput(object);
        try {
            SerialOutput jos = new SerialOutput(fo, this.classCatalog);
            jos.writeObject(object);
        }
        catch (IOException e) {
            throw new RuntimeExceptionWrapper(e);
        }
        byte[] hdr = SerialOutput.getStreamHeader();
        entry.setData(fo.getBufferBytes(), hdr.length, fo.getBufferLength() - hdr.length);
    }
}

