/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.util.debug.FileAppender;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import junit.framework.TestCase;

public abstract class FTPTestCase
extends TestCase {
    private static String cvsId = "@(#)$Id: FTPTestCase.java,v 1.9 2004/07/23 08:33:44 bruceb Exp $";
    protected Logger log = Logger.getLogger(class$com$enterprisedt$net$ftp$test$FTPTestCase == null ? (class$com$enterprisedt$net$ftp$test$FTPTestCase = FTPTestCase.class$("com.enterprisedt.net.ftp.test.FTPTestCase")) : class$com$enterprisedt$net$ftp$test$FTPTestCase);
    protected FTPClient ftp;
    protected String host;
    protected String user;
    protected String password;
    protected FTPConnectMode connectMode;
    protected int timeout;
    protected String testdir;
    protected String remoteTextFile;
    protected String localTextFile;
    protected String remoteBinaryFile;
    protected String localBinaryFile;
    protected String localEmptyFile;
    protected String remoteEmptyFile;
    protected String remoteEmptyDir;
    protected boolean strictReplies = true;
    protected Properties props = new Properties();
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$FTPTestCase;

    public FTPTestCase() {
        Logger.setLevel(Level.ALL);
        try {
            this.props.load(new FileInputStream("test.properties"));
        }
        catch (IOException ex) {
            System.out.println("Failed to open test.properties");
            System.exit(-1);
        }
        this.host = this.props.getProperty("ftptest.host");
        this.user = this.props.getProperty("ftptest.user");
        this.password = this.props.getProperty("ftptest.password");
        String connectMode = System.getProperty("ftptest.connectmode");
        this.connectMode = connectMode != null && connectMode.equalsIgnoreCase("active") ? FTPConnectMode.ACTIVE : FTPConnectMode.PASV;
        String timeout = this.props.getProperty("ftptest.timeout");
        this.timeout = Integer.parseInt(timeout);
        String strict = this.props.getProperty("ftptest.strictreplies");
        this.strictReplies = strict == null || !strict.equalsIgnoreCase("false");
        this.testdir = this.props.getProperty("ftptest.testdir");
        this.localTextFile = this.props.getProperty("ftptest.file.local.text");
        this.remoteTextFile = this.props.getProperty("ftptest.file.remote.text");
        this.localBinaryFile = this.props.getProperty("ftptest.file.local.binary");
        this.remoteBinaryFile = this.props.getProperty("ftptest.file.remote.binary");
        this.localEmptyFile = this.props.getProperty("ftptest.file.local.empty");
        this.remoteEmptyFile = this.props.getProperty("ftptest.file.remote.empty");
        this.remoteEmptyDir = this.props.getProperty("ftptest.dir.remote.empty");
    }

    protected void setUp() throws Exception {
        Logger.addAppender(new FileAppender(this.getLogName()));
        int[] ver = FTPClient.getVersion();
        this.log.info("FTP version: " + ver[0] + "." + ver[1] + "." + ver[2]);
        this.log.info("FTP build timestamp: " + FTPClient.getBuildTimestamp());
    }

    protected void tearDown() throws Exception {
        Logger.shutdown();
    }

    protected void connect() throws Exception {
        this.connect(0);
    }

    protected void connect(int timeout) throws Exception {
        this.ftp = new FTPClient(this.host, 21, timeout);
        this.ftp.setConnectMode(this.connectMode);
        if (!this.strictReplies) {
            this.log.warn("Strict replies not enabled");
            this.ftp.setStrictReturnCodes(false);
        }
    }

    protected void login() throws Exception {
        this.ftp.login(this.user, this.password);
    }

    protected String generateRandomFilename() {
        Date now = new Date();
        Long ms = new Long(now.getTime());
        return ms.toString();
    }

    protected void assertIdentical(byte[] buf1, byte[] buf2) throws Exception {
        FTPTestCase.assertEquals((int)buf1.length, (int)buf2.length);
        for (int i = 0; i < buf1.length; ++i) {
            FTPTestCase.assertEquals((byte)buf1[i], (byte)buf2[i]);
        }
    }

    protected void assertIdentical(String file1, String file2) throws Exception {
        File f1 = new File(file1);
        File f2 = new File(file2);
        this.assertIdentical(f1, f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void assertIdentical(File file1, File file2) throws Exception {
        BufferedInputStream is2;
        block8: {
            BufferedInputStream is1 = null;
            is2 = null;
            try {
                try {
                    FTPTestCase.assertEquals((long)file1.length(), (long)file2.length());
                    this.log.debug("Identical size [" + file1.getName() + "," + file2.getName() + "]");
                    is1 = new BufferedInputStream(new FileInputStream(file1));
                    is2 = new BufferedInputStream(new FileInputStream(file2));
                    int ch1 = 0;
                    int ch2 = 0;
                    while ((ch1 = is1.read()) != -1 && (ch2 = is2.read()) != -1) {
                        FTPTestCase.assertEquals((int)ch1, (int)ch2);
                    }
                    this.log.debug("Contents equal");
                }
                catch (IOException ex) {
                    FTPTestCase.fail((String)("Caught exception: " + ex.getMessage()));
                    Object var8_9 = null;
                    if (is1 != null) {
                        is1.close();
                    }
                    if (is2 == null) return;
                    is2.close();
                    return;
                }
                Object var8_8 = null;
                if (is1 == null) break block8;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (is1 != null) {
                    is1.close();
                }
                if (is2 == null) throw throwable;
                is2.close();
                throw throwable;
            }
            is1.close();
        }
        if (is2 == null) return;
        is2.close();
    }

    protected abstract String getLogName();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

