/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.XmlHelper;

public class XmlDocumentConfig
implements Cloneable {
    public static final XmlDocumentConfig DEFAULT = new XmlDocumentConfig();
    private boolean lazyDocs = false;
    private boolean documentProjection = false;
    private boolean genName = false;
    private LockMode lockMode = null;
    private boolean wellFormedOnly = false;
    private boolean reverseOrder = false;
    private boolean cacheDocuments = false;
    private boolean documentsOnly = false;
    private boolean autoCommit = true;

    public boolean getLazyDocs() {
        return this.lazyDocs;
    }

    public XmlDocumentConfig setLazyDocs(boolean value) {
        this.lazyDocs = value;
        return this;
    }

    public boolean getDocumentProjection() {
        return this.documentProjection;
    }

    public XmlDocumentConfig setDocumentProjection(boolean value) {
        this.documentProjection = value;
        return this;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public XmlDocumentConfig setAutoCommit(boolean value) {
        this.autoCommit = value;
        return this;
    }

    public boolean getReverseOrder() {
        return this.reverseOrder;
    }

    public XmlDocumentConfig setReverseOrder(boolean value) {
        this.reverseOrder = value;
        return this;
    }

    public boolean getCacheDocuments() {
        return this.cacheDocuments;
    }

    public XmlDocumentConfig setCacheDocuments(boolean value) {
        this.cacheDocuments = value;
        return this;
    }

    public boolean getDocumentsOnly() {
        return this.documentsOnly;
    }

    public XmlDocumentConfig setDocumentsOnly(boolean value) {
        this.documentsOnly = value;
        return this;
    }

    public boolean getWellFormedOnly() {
        return this.wellFormedOnly;
    }

    public XmlDocumentConfig setWellFormedOnly(boolean value) {
        this.wellFormedOnly = value;
        return this;
    }

    public boolean getGenerateName() {
        return this.genName;
    }

    public XmlDocumentConfig setGenerateName(boolean value) {
        this.genName = value;
        return this;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public XmlDocumentConfig setLockMode(LockMode lmode) {
        this.lockMode = lmode;
        return this;
    }

    int makeFlags() {
        int flags = 0;
        if (this.lazyDocs) {
            flags |= 0x800000;
        }
        if (this.documentProjection) {
            flags |= Integer.MIN_VALUE;
        }
        if (!this.autoCommit) {
            flags |= 0x10000;
        }
        if (this.genName) {
            flags |= 0x2000000;
        }
        if (this.reverseOrder) {
            flags |= 0x100000;
        }
        if (this.cacheDocuments) {
            flags |= 0x400000;
        }
        if (this.documentsOnly) {
            flags |= 0x10000;
        }
        if (this.wellFormedOnly) {
            flags |= 0x1000000;
        }
        if (this.lockMode != null) {
            try {
                flags |= XmlHelper.getFlag(this.lockMode);
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        return flags;
    }
}

