/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marcxml;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import org.marc4j.ErrorHandler;
import org.marc4j.MarcHandler;
import org.marc4j.MarcReader;
import org.marc4j.marc.Leader;
import org.marc4j.marcxml.DoctypeDecl;
import org.marc4j.marcxml.ExtendedFilter;
import org.marc4j.util.CharacterConverter;
import org.marc4j.util.CharacterConverterLoader;
import org.marc4j.util.CharacterConverterLoaderException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;

public class MarcXmlFilter
extends ExtendedFilter
implements MarcHandler {
    private boolean prettyPrinting = true;
    private static final Attributes EMPTY_ATTS = new AttributesImpl();
    private static final String ERROR_HANDLER = "http://marc4j.org/properties/error-handler";
    private static final String ANSEL_TO_UNICODE = "http://marc4j.org/features/ansel-to-unicode";
    private static final String CHARACTER_CONVERTER = "http://marc4j.org/properties/character-conversion";
    private static final String PRETTY_PRINTING = "http://marc4j.org/features/pretty-printing";
    private static final String DOC_TYPE_DECL = "http://marc4j.org/properties/document-type-declaration";
    private static final String SCHEMA_LOC = "http://marc4j.org/properties/schema-location";
    private static final String NS_URI = "http://www.loc.gov/MARC21/slim";
    private static final String NS_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    private String schemaLocation = null;
    private DoctypeDecl doctype = null;
    private ContentHandler ch;
    private ErrorHandler eh;
    private CharacterConverter charconv = null;

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (DOC_TYPE_DECL.equals(string)) {
            this.doctype = (DoctypeDecl)object;
        } else if (ERROR_HANDLER.equals(string)) {
            this.eh = (ErrorHandler)object;
        } else if (SCHEMA_LOC.equals(string)) {
            this.schemaLocation = (String)object;
        } else if (CHARACTER_CONVERTER.equals(string)) {
            this.charconv = (CharacterConverter)object;
        } else {
            super.setProperty(string, object);
        }
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (ANSEL_TO_UNICODE.equals(string)) {
            this.setCharacterConverter(true);
        } else if (PRETTY_PRINTING.equals(string)) {
            this.prettyPrinting = bl;
        } else {
            super.setFeature(string, bl);
        }
    }

    public void parse(InputSource inputSource) {
        this.ch = this.getContentHandler();
        if (this.ch == null) {
            return;
        }
        try {
            Object object;
            BufferedReader bufferedReader = null;
            if (inputSource.getCharacterStream() != null) {
                bufferedReader = new BufferedReader(inputSource.getCharacterStream());
            } else if (inputSource.getByteStream() != null) {
                bufferedReader = new BufferedReader(new InputStreamReader(inputSource.getByteStream(), "ISO8859_1"));
            } else if (inputSource.getSystemId() != null) {
                object = new URL(inputSource.getSystemId());
                bufferedReader = new BufferedReader(new InputStreamReader(((URL)object).openStream(), "ISO8859_1"));
            } else {
                throw new SAXException("Invalid InputSource object");
            }
            object = new MarcReader();
            ((MarcReader)object).setMarcHandler(this);
            if (this.eh != null) {
                ((MarcReader)object).setErrorHandler(this.eh);
            }
            ((MarcReader)object).parse(bufferedReader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startCollection() {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            this.ch.startDocument();
            if (this.lh != null && this.doctype != null && this.schemaLocation == null) {
                this.lh.startDTD(this.doctype.getName(), this.doctype.getPublicId(), this.doctype.getSystemId());
                this.lh.endDTD();
            }
            if (this.schemaLocation != null) {
                attributesImpl.addAttribute("", "xsi", "xmlns:xsi", "CDATA", NS_XSI);
                attributesImpl.addAttribute(NS_XSI, "schemaLocation", "xsi:schemaLocation", "CDATA", this.schemaLocation);
            }
            if (this.doctype == null) {
                attributesImpl.addAttribute("", "", "xmlns", "CDATA", NS_URI);
            }
            this.ch.startPrefixMapping("", NS_URI);
            this.ch.startElement(NS_URI, "collection", "collection", attributesImpl);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public void startRecord(Leader leader) {
        try {
            if (this.prettyPrinting) {
                this.ch.ignorableWhitespace("\n  ".toCharArray(), 0, 3);
            }
            this.ch.startElement(NS_URI, "record", "record", EMPTY_ATTS);
            if (this.prettyPrinting) {
                this.ch.ignorableWhitespace("\n    ".toCharArray(), 0, 5);
            }
            this.writeElement(NS_URI, "leader", "leader", EMPTY_ATTS, leader.marshal());
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public void controlField(String string, char[] cArray) {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "tag", "tag", "CDATA", string);
            if (this.prettyPrinting) {
                this.ch.ignorableWhitespace("\n    ".toCharArray(), 0, 5);
            }
            this.writeElement(NS_URI, "controlfield", "controlfield", (Attributes)attributesImpl, cArray);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public void startDataField(String string, char c, char c2) {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "tag", "tag", "CDATA", string);
            attributesImpl.addAttribute("", "ind1", "ind1", "CDATA", String.valueOf(c));
            attributesImpl.addAttribute("", "ind2", "ind2", "CDATA", String.valueOf(c2));
            if (this.prettyPrinting) {
                this.ch.ignorableWhitespace("\n    ".toCharArray(), 0, 5);
            }
            this.ch.startElement(NS_URI, "datafield", "datafield", attributesImpl);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public void subfield(char c, char[] cArray) {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "code", "code", "CDATA", String.valueOf(c));
            if (this.prettyPrinting) {
                this.ch.ignorableWhitespace("\n      ".toCharArray(), 0, 7);
            }
            this.ch.startElement(NS_URI, "subfield", "subfield", attributesImpl);
            if (this.charconv != null) {
                char[] cArray2 = this.charconv.convert(cArray);
                this.ch.characters(cArray2, 0, cArray2.length);
            } else {
                this.ch.characters(cArray, 0, cArray.length);
            }
            this.ch.endElement(NS_URI, "subfield", "subfield");
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public void endDataField(String string) {
        try {
            this.ch.ignorableWhitespace("\n    ".toCharArray(), 0, 5);
            this.ch.endElement(NS_URI, "datafield", "datafield");
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public void endRecord() {
        try {
            if (this.prettyPrinting) {
                this.ch.ignorableWhitespace("\n  ".toCharArray(), 0, 3);
            }
            this.ch.endElement(NS_URI, "record", "record");
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public void endCollection() {
        try {
            if (this.prettyPrinting) {
                this.ch.ignorableWhitespace("\n".toCharArray(), 0, 1);
            }
            this.ch.endElement(NS_URI, "collection", "collection");
            this.ch.endPrefixMapping("");
            this.ch.endDocument();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    private void writeElement(String string, String string2, String string3, Attributes attributes, String string4) throws SAXException {
        this.writeElement(string, string2, string3, attributes, string4.toCharArray());
    }

    private void writeElement(String string, String string2, String string3, Attributes attributes, char c) throws SAXException {
        this.writeElement(string, string2, string3, attributes, String.valueOf(c).toCharArray());
    }

    private void writeElement(String string, String string2, String string3, Attributes attributes, char[] cArray) throws SAXException {
        this.ch.startElement(string, string2, string3, attributes);
        this.ch.characters(cArray, 0, cArray.length);
        this.ch.endElement(string, string2, string3);
    }

    private void setCharacterConverter(boolean bl) {
        block2: {
            if (!bl) break block2;
            try {
                this.charconv = (CharacterConverter)CharacterConverterLoader.createCharacterConverter("org.marc4j.charconv", "org.marc4j.util.AnselToUnicode");
            }
            catch (CharacterConverterLoaderException characterConverterLoaderException) {
                characterConverterLoaderException.printStackTrace();
            }
        }
    }
}

