/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Random;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLNotNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.CQLTermNode;
import org.z3950.zing.cql.MissingParameterException;

public class CQLGenerator {
    private static boolean DEBUG = false;
    Properties params;
    Random rnd;

    private static final void debug(String string) {
        if (DEBUG) {
            System.err.println("DEBUG: " + string);
        }
    }

    public CQLNode generate() throws MissingParameterException {
        return this.generate_cql_query();
    }

    private final CQLNode generate_cql_query() throws MissingParameterException {
        if (!this.maybe("complexQuery")) {
            return this.generate_search_clause();
        }
        CQLNode cQLNode = this.generate_cql_query();
        CQLNode cQLNode2 = this.generate_search_clause();
        if (!this.maybe("proxOp")) {
            switch (this.rnd.nextInt(3)) {
                case 0: {
                    return new CQLAndNode(cQLNode, cQLNode2);
                }
                case 1: {
                    return new CQLOrNode(cQLNode, cQLNode2);
                }
                case 2: {
                    return new CQLNotNode(cQLNode, cQLNode2);
                }
            }
        }
        return this.generate_search_clause();
    }

    private final CQLNode generate_search_clause() throws MissingParameterException {
        if (this.maybe("complexClause")) {
            return this.generate_cql_query();
        }
        String string = this.generate_qualifier();
        CQLRelation cQLRelation = this.generate_relation();
        String string2 = this.generate_term();
        return new CQLTermNode(string, cQLRelation, string2);
    }

    private final String generate_qualifier() {
        String string = "";
        if (this.rnd.nextInt(2) == 0) {
            switch (this.rnd.nextInt(3)) {
                case 0: {
                    string = "dc.author";
                    break;
                }
                case 1: {
                    string = "dc.title";
                    break;
                }
                case 2: {
                    string = "dc.subject";
                    break;
                }
            }
        } else {
            switch (this.rnd.nextInt(4)) {
                case 0: {
                    string = "bath.author";
                    break;
                }
                case 1: {
                    string = "bath.title";
                    break;
                }
                case 2: {
                    string = "bath.subject";
                    break;
                }
                case 3: {
                    string = "foo>bar";
                    break;
                }
            }
        }
        return string;
    }

    private final CQLRelation generate_relation() throws MissingParameterException {
        String string = this.generate_base_relation();
        CQLRelation cQLRelation = new CQLRelation(string);
        return cQLRelation;
    }

    private final String generate_base_relation() throws MissingParameterException {
        if (this.maybe("equalsRelation")) {
            return "=";
        }
        if (this.maybe("numericRelation")) {
            return this.generate_numeric_relation();
        }
        switch (this.rnd.nextInt(3)) {
            case 0: {
                return "exact";
            }
            case 1: {
                return "all";
            }
            case 2: {
                return "any";
            }
        }
        return "";
    }

    private final String generate_term() {
        switch (this.rnd.nextInt(10)) {
            case 0: {
                return "cat";
            }
            case 1: {
                return "\"cat\"";
            }
            case 2: {
                return "comp.os.linux";
            }
            case 3: {
                return "xml:element";
            }
            case 4: {
                return "<xml.element>";
            }
            case 5: {
                return "prox/word/>=/5";
            }
            case 6: {
                return "";
            }
            case 7: {
                return "frog fish";
            }
            case 8: {
                return "the complete dinosaur";
            }
            case 9: {
                return "foo*bar";
            }
        }
        return "";
    }

    private final String generate_numeric_relation() {
        switch (this.rnd.nextInt(6)) {
            case 0: {
                return "<";
            }
            case 1: {
                return ">";
            }
            case 2: {
                return "<=";
            }
            case 3: {
                return ">=";
            }
            case 4: {
                return "<>";
            }
            case 5: {
                return "=";
            }
        }
        return "";
    }

    boolean maybe(String string) throws MissingParameterException {
        double d;
        String string2 = this.params.getProperty(string);
        if (string2 == null) {
            throw new MissingParameterException(string);
        }
        double d2 = this.rnd.nextDouble();
        boolean bl = d2 < (d = new Double(string2).doubleValue());
        CQLGenerator.debug("dice=" + String.valueOf(d2).substring(0, 8) + " vs. " + d + "='" + string + "': " + bl);
        return bl;
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        FileInputStream fileInputStream;
        if (stringArray.length % 2 != 1) {
            System.err.println("Usage: CQLGenerator <props-file> [<name> <value>]...");
            System.exit(1);
        }
        if ((fileInputStream = new FileInputStream(string = stringArray[0])) == null) {
            throw new FileNotFoundException(string);
        }
        Properties properties = new Properties();
        properties.load(fileInputStream);
        ((InputStream)fileInputStream).close();
        int n = 1;
        while (n < stringArray.length) {
            properties.setProperty(stringArray[n], stringArray[n + 1]);
            n += 2;
        }
        CQLGenerator cQLGenerator = new CQLGenerator(properties);
        CQLNode cQLNode = cQLGenerator.generate();
        System.out.println(cQLNode.toCQL());
    }

    public CQLGenerator(Properties properties) {
        this.params = properties;
        String string = properties.getProperty("seed");
        this.rnd = string != null ? new Random(new Long(string)) : new Random();
    }
}

